﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Threading.Tasks;
using VA.TMP.Integration.VIMT.HealthShare.Links;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Shared;
using Vimt.HealthShare.Messages.Messages;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.GetConsults
{
    public class SendToEcStep : FilterBase<GetConsultsStateObject>
    {
        public override void Execute(GetConsultsStateObject state)
        {
            if (!string.IsNullOrEmpty(state.ConsultsFakeResponseType))
            {
                Logger.Instance.Info("Currently Fakes is turned ON. Refer to 'Vista - Get Consult Fake Response Type' under integration settings. " + "Returning with the fake response instead of HealthShare REST call");
                var fakeEcResponse = HealthShareFakeResponses.FakeGetConsultsForPatientSuccess();
                if (state.PatEcRequestMessage != null) state.PatEcResponseMessage = fakeEcResponse;
                if (state.ProEcRequestMessage != null) state.ProEcResponseMessage = fakeEcResponse;
            }
            else
            {
                try
                {
                    Logger.Instance.Info("Currently Fakes is turned OFF. Initiating the HealthShare Get Consults for Patients REST call");
                    const string providerKey = "Pro";
                    const string patientKey = "Pat";

                    var requestKvps = new List<KeyValuePair<string, VimtHealthShareGetConsultsRequest>>
                    {
                        new KeyValuePair<string, VimtHealthShareGetConsultsRequest>(patientKey, state.PatEcRequestMessage),
                        new KeyValuePair<string, VimtHealthShareGetConsultsRequest>(providerKey, state.ProEcRequestMessage)
                    };

                    var timer = new Stopwatch();
                    timer.Start();

                    Parallel.ForEach(requestKvps, request =>
                    {
                        if (request.Key == patientKey && state.PatEcRequestMessage != null) state.PatEcResponseMessage = state.PatEcRequestMessage.SendReceive<VimtHealthShareGetConsultsResponse>(MessageProcessType.Local);
                        if (request.Key == providerKey && state.ProEcRequestMessage != null) state.ProEcResponseMessage = state.ProEcRequestMessage.SendReceive<VimtHealthShareGetConsultsResponse>(MessageProcessType.Local);
                    });

                    timer.Stop();
                    state.EcProcessingTimeMs += (int)timer.ElapsedMilliseconds;
                }
                catch (Exception ex)
                {
                    state.ExceptionOccured = true;
                    state.ExceptionMessage = PipelineUtilities.BuildErrorMessage(ex);
                    throw new Exception($"HealthShare Get Consults SendToEcStep Pipeline Error: {ex.Message}", ex.InnerException);
                }
            }
        }
    }
}